/*******************************************************************************
*                         USB4ALLAPI Library Version 1.0                       *
********************************************************************************
* FileName: U4AAPI.h                                                           *
*                                                                              *
* Author                     Date           Version                            *
*------------------------------------------------------------------------------*
* Carlos Grossy              21/03/2007       1.0                              *
* Carlos Grossy              05/04/2007       1.1                              *
* Carlos Grossy              02/06/2007       1.2                              *
*******************************************************************************/

#ifndef _U4AAPI_H_
#define _U4AAPI_H_

#ifdef _BUILDING_USB4ALLAPI
	#define _IMPEXP_USB4ALLAPI __declspec(dllexport)
#else
    #define _IMPEXP_USB4ALLAPI __declspec(dllimport)
#endif

class commandLayer;
class handlerLayer;
class log;

class _IMPEXP_USB4ALLAPI u4a {
    private:
        u4a();
        static u4a *instance;
        static bool borrado;
        static u4a *getInstance();
        commandLayer *cl;
        handlerLayer *hl;
        log *l;
    public:
        ~u4a();
        int* getU4ABoards(int&);
        int openDevice(int, char *, int, int);
        bool configDevice(int, char *);
        bool sendData(int, char *, int, int);
        bool receiveData(int, char *, int, int);
        bool closeDevice(int);
        int apiVersion();
        int firmwareVersion();
        int getSerialNumber(int);
};

#endif
